
`Light data
type Lighting_LightData
   InUse as integer
   LightArray as integer
   PointLight as integer
   SpotLight as integer
   Dist as float
   InScreen as integer
   Active as integer
   Visible as integer
   CullDist as float
   LightUpdate as integer
   Shadows as integer
   ShadowUpdate as integer
   ShadowUpdateTime as float
   ShadowUpdatePos as Vec4Integer
   ShadowUpdateAng as Vec4Integer
   ShadowCullDist as float
   ShadowPoint as integer
   ShadowSpot as integer
   ShadowNear as integer
   Masked as integer
   MaskUpdate as integer
   Texture as integer
   Position as Vec3Float
   Color as Vec4Float
   Range as float
   Angle as Vec3Float
   Direction as Vec3Float
   Cone as Vec4Float
   Offset as Vec4Float
   MatAng1 as Vec3Float
   MatAng2 as Vec3Float
   MatAng3 as Vec3Float
endtype

`Light Mask data
type Lighting_LightShaderData
   InUse as integer
   Object as integer
   Effect as integer
   Shader as integer
   ShaderMode as integer
   Array as integer
   ShadowMap as integer
endtype

`--------------
` Set Fog Color
`--------------
function FogSetColor(iRed as float,iGreen as float,iBlue as float,iRange as float)
   Lighting_Fog.x=iRed
   Lighting_Fog.y=iGreen
   Lighting_Fog.z=iBlue
   Lighting_Fog.w=iRange
   for e=0 to Lighting_EffectsCount
      if Lighting_Effects[e].InUse=1 then SetShaderConstantByName(Effects[Lighting_Effects[e].Effect].Shader[0],"FogColor",((Lighting_Fog.x/255)^2.2),((Lighting_Fog.y/255)^2.2),((Lighting_Fog.z/255)^2.2),Lighting_Fog.w)
   next e
endfunction

`--------------
` Set Ambient Color
`--------------
function AmbientSetColor(iRed as float,iGreen as float,iBlue as float)
   Lighting_AmbientColor.x=iRed
   Lighting_AmbientColor.y=iGreen
   Lighting_AmbientColor.z=iBlue
   for e=0 to Lighting_EffectsCount
      if Lighting_Effects[e].InUse=1 then SetShaderConstantByName(Effects[Lighting_Effects[e].Effect].Shader[0],"AmbientColor",((Lighting_AmbientColor.x/255)^2.2),((Lighting_AmbientColor.y/255)^2.2),((Lighting_AmbientColor.z/255)^2.2),0)
   next e
endfunction

`--------------
` Set Shadows Quality
`--------------
function ShadowsQuality(iQuality as integer)
   if Lighting_ShadowsQuality<>iQuality
      Lighting_ShadowsQuality=iQuality
      if Lighting_ShadowsQuality>1 then Lighting_ShadowsQuality=1
      if Lighting_ShadowsQuality<0 then Lighting_ShadowsQuality=0
      if Lighting_ShadowsQuality=0 then SetEffectTechnique(Lighting_Effect[1],"Directional0")
      if Lighting_ShadowsQuality=1 then SetEffectTechnique(Lighting_Effect[1],"Directional1")
   endif
endfunction

`--------------
` Enable SSAO
`--------------
function EnableSSAO(iSSAO as integer)
   if Lighting_SSAOenabled<>iSSAO
      Lighting_SSAOenabled=iSSAO
      if Lighting_SSAOenabled=1
         SetObjectImage(Lighting_Object[1],Lighting_Image[2],5)
      else
         SetObjectImage(Lighting_Object[1],Lighting_Image[10],5)
      endif
   endif
endfunction

`--------------
` Set Directional Light Angle
`--------------
function DirectionalLightSetAngle(iAngX as float,iAngY as float,iAngZ as float)
   if Lighting_LightDirectionAngle.x<>iAngX or Lighting_LightDirectionAngle.y<>iAngY or Lighting_LightDirectionAngle.z<>iAngZ
      Lighting_LightDirectionAngle.x=wrapvalue(iAngX)
      Lighting_LightDirectionAngle.y=wrapvalue(iAngY)
      Lighting_LightDirectionAngle.z=wrapvalue(iAngZ)
      RotateX_Matrix4(1,WrapValue(Lighting_LightDirectionAngle.x)*0.01745329251)
      RotateY_Matrix4(2,WrapValue(Lighting_LightDirectionAngle.y)*0.01745329251)
      RotateZ_Matrix4(3,WrapValue(Lighting_LightDirectionAngle.z)*0.01745329251)
      Multiply_Matrix4(4,1,2)
      Multiply_Matrix4(4,4,3)
      Set_Vector3(1,0,0,1)
      Transform_Normals_Vector3(1,1,4)
      Lighting_LightDirection.x=-Vector3Float[1].x
      Lighting_LightDirection.y=-Vector3Float[1].y
      Lighting_LightDirection.z=-Vector3Float[1].z
      for e=0 to Lighting_EffectsCount
         if Lighting_Effects[e].InUse=1 then SetShaderConstantByName(Effects[Lighting_Effects[e].Effect].Shader[0],"LightDirection",Lighting_LightDirection.x,Lighting_LightDirection.y,Lighting_LightDirection.z,0)
      next e
   endif
endfunction

`--------------
` Set Directional Light Color
`--------------
function DirectionalLightSetColor(iRed as float,iGreen as float,iBlue as float)
   if Lighting_LightDirectionColor.x<>iRed or Lighting_LightDirectionColor.y<>iGreen or Lighting_LightDirectionColor.z<>iBlue
      Lighting_LightDirectionColor.x=iRed
      Lighting_LightDirectionColor.y=iGreen
      Lighting_LightDirectionColor.z=iBlue
      for e=0 to Lighting_EffectsCount
         if Lighting_Effects[e].InUse=1 then SetShaderConstantByName(Effects[Lighting_Effects[e].Effect].Shader[0],"LightDirectionColor",((Lighting_LightDirectionColor.x/255)^2.2),((Lighting_LightDirectionColor.y/255)^2.2),((Lighting_LightDirectionColor.z/255)^2.2),0)
      next e
   endif
endfunction

`--------------
` Add Light
`--------------
function AddLight()
   tLight=-1
   for l=Lighting_LightsFreeUp to Lighting_LightsCount
      if Lighting_Lights[l].InUse=0 and Lighting_Lights[l].Active=0 
         tLight=l
         exit
      endif
   next l
   if tLight=-1
      inc Lighting_LightsCount
      Lighting_Lights.length=Lighting_Lights.length+1
      Lighting_LightUpdate.length=Lighting_LightUpdate.length+1
      Lighting_LightUpdateMask.length=Lighting_LightUpdateMask.length+1
      tLight=Lighting_LightsCount
   endif
   Lighting_LightsFreeUp=tLight
   Lighting_Lights[tLight].InUse=1
   Lighting_Lights[tLight].visible=1
   Lighting_Lights[tLight].CullDist=2000
   Lighting_Lights[tLight].ShadowCullDist=750
   Lighting_Lights[tLight].Position.x=0 : Lighting_Lights[tLight].Position.y=0 : Lighting_Lights[tLight].Position.z=0
   Lighting_Lights[tLight].Color.x=255 : Lighting_Lights[tLight].Color.y=255 : Lighting_Lights[tLight].Color.z=255
   Lighting_Lights[tLight].Color.w=1
   Lighting_Lights[tLight].Range=500
   Lighting_Lights[tLight].Texture=0
   Lighting_Lights[tLight].Shadows=1
   Lighting_Lights[tLight].Angle.x=1
   LightSetAngle(tLight,0,0,0,0,0)
   LightBoundsUpdate(tLight)
endfunction tLight

`--------------
` Remove Light
`--------------
function RemoveLight(iLight as integer)
   if Lighting_Lights[iLight].InUse=1
      Lighting_Lights[iLight].InUse=0
      LightsRemoveArray(iLight)
      LightsRemovePoint(iLight)
      LightsRemoveSpot(iLight)
      if Lighting_LightsFreeUp>iLight then Lighting_LightsFreeUp=iLight
      if Lighting_Lights[iLight].Active>0
         tIndex=Lighting_Lights[iLight].Active-1
         if tIndex<Lighting_LightsActiveCount
            tActive=Lighting_LightsActive[Lighting_LightsActiveCount]-1
            Lighting_Lights[tActive].Active=tIndex+1
            Lighting_LightsActive[tIndex]=tActive+1
         endif
         dec Lighting_LightsActiveCount : Lighting_Lights[iLight].Active=0
      endif
      if Lighting_Lights[iLight].ShadowPoint>0 
         Lighting_ShadowPointLight[Lighting_Lights[iLight].ShadowPoint-1]=0:Lighting_Lights[iLight].ShadowPoint=0
      endif
      if Lighting_Lights[iLight].ShadowSpot>0 
         Lighting_ShadowSpotLight[Lighting_Lights[iLight].ShadowSpot-1]=0:Lighting_Lights[iLight].ShadowSpot=0
      endif
      if Lighting_Lights[iLight].Masked>0 then dec Lighting_LightMaskCount[Lighting_Lights[iLight].Masked]
      Lighting_Lights[iLight].Masked=0
      Lighting_Lights[iLight].LightUpdate=0
      Lighting_Lights[iLight].MaskUpdate=0
   endif
endfunction

`--------------
` Set Light Visible
`--------------
function LightSetVisible(iLight as integer,ivisible as integer)
   if Lighting_Lights[iLight].InUse=1
      if Lighting_Lights[iLight].visible<>ivisible 
         Lighting_Lights[iLight].visible=ivisible
      endif
   endif
endfunction

`--------------
` Set Light Cull Dist
`--------------
function LightSetCull(iLight as integer,iCullDist as float)
   if Lighting_Lights[iLight].InUse=1 then Lighting_Lights[iLight].CullDist=iCullDist
endfunction

`--------------
` Set Light Position
`--------------
function LightSetPosition(iLight as integer,iPosX as float,iPosY as float,iPosZ as float)
   if Lighting_Lights[iLight].InUse=1
      if Lighting_Lights[iLight].Position.x<>iPosX or Lighting_Lights[iLight].Position.y<>iPosY or Lighting_Lights[iLight].Position.z<>iPosZ
         Lighting_Lights[iLight].Position.x=iPosX
         Lighting_Lights[iLight].Position.y=iPosY
         Lighting_Lights[iLight].Position.z=iPosZ
         LightUpdate(iLight)
         LightMaskUpdate(iLight)
         LightBoundsUpdate(iLight)
         if Lighting_Lights[iLight].ShadowUpdatePos.x<>round(Lighting_Lights[iLight].Position.x*4) or Lighting_Lights[iLight].ShadowUpdatePos.y<>round(Lighting_Lights[iLight].Position.y*4) or Lighting_Lights[iLight].ShadowUpdatePos.z<>round(Lighting_Lights[iLight].Position.z*4)
            Lighting_Lights[iLight].ShadowUpdatePos.x=round(Lighting_Lights[iLight].Position.x*4)
            Lighting_Lights[iLight].ShadowUpdatePos.y=round(Lighting_Lights[iLight].Position.y*4)
            Lighting_Lights[iLight].ShadowUpdatePos.z=round(Lighting_Lights[iLight].Position.z*4)
            Lighting_Lights[iLight].ShadowUpdate=1
         endif
      endif
   endif
endfunction

`--------------
` Set Light Color
`--------------
function LightSetColor(iLight as integer,iRed as float,iGreen as float,iBlue as float)
   if Lighting_Lights[iLight].InUse=1
      if Lighting_Lights[iLight].Color.x<>iRed or Lighting_Lights[iLight].Color.y<>iGreen or Lighting_Lights[iLight].Color.z<>iBlue
         Lighting_Lights[iLight].Color.x=iRed
         Lighting_Lights[iLight].Color.y=iGreen
         Lighting_Lights[iLight].Color.z=iBlue
         LightUpdate(iLight)
      endif
   endif
endfunction

`--------------
` Set Light Intensity
`--------------
function LightSetIntensity(iLight as integer,iIntensity as float)
   if Lighting_Lights[iLight].InUse=1
      if Lighting_Lights[iLight].Color.w<>iIntensity
         Lighting_Lights[iLight].Color.w=iIntensity
         LightUpdate(iLight)
      endif
   endif
endfunction

`--------------
` Set Light Range
`--------------
function LightSetRange(iLight as integer,iRange as float)
   if Lighting_Lights[iLight].InUse=1
      if Lighting_Lights[iLight].Range<>iRange
         Lighting_Lights[iLight].Range=iRange
         LightUpdate(iLight)
         LightMaskUpdate(iLight)
         LightBoundsUpdate(iLight)
         if Lighting_Lights[iLight].ShadowUpdatePos.w<>round(Lighting_Lights[iLight].Range)
            Lighting_Lights[iLight].ShadowUpdatePos.w=round(Lighting_Lights[iLight].Range)
            Lighting_Lights[iLight].ShadowUpdate=1
         endif
      endif
   endif
endfunction

`--------------
` Set Light Angle
`--------------
function LightSetAngle(iLight as integer,iAngX as float,iAngY as float,iAngZ as float,iSpotOuterAngle as float,iSpotInnerAngle as float)
   if Lighting_Lights[iLight].InUse=1
      if Lighting_Lights[iLight].Angle.x<>iAngX or Lighting_Lights[iLight].Angle.y<>iAngY or Lighting_Lights[iLight].Angle.z<>iAngZ or Lighting_Lights[iLight].Cone.z<>iSpotOuterAngle or Lighting_Lights[iLight].Cone.w<>iSpotInnerAngle
         if Lighting_Lights[iLight].Cone.z=0 and iSpotOuterAngle>0 then tRemoveMask=1
         if Lighting_Lights[iLight].Cone.z>0 and iSpotOuterAngle=0 then tRemoveMask=1
         if tRemoveMask=1
            LightsRemovePoint(iLight)
            LightsRemoveSpot(iLight)
         endif
         Lighting_Lights[iLight].Angle.x=iAngX
         Lighting_Lights[iLight].Angle.y=iAngY
         Lighting_Lights[iLight].Angle.z=iAngZ
         RotateX_Matrix4(1,WrapValue(Lighting_Lights[iLight].Angle.x)*0.01745329251)
         RotateY_Matrix4(2,WrapValue(Lighting_Lights[iLight].Angle.y)*0.01745329251)
         RotateZ_Matrix4(3,WrapValue(Lighting_Lights[iLight].Angle.z)*0.01745329251)
         Multiply_Matrix4(4,1,2)
         Multiply_Matrix4(4,4,3)
         Lighting_Lights[iLight].MatAng1.x=Matrix4Float[4,1].x : Lighting_Lights[iLight].MatAng1.y=Matrix4Float[4,2].x : Lighting_Lights[iLight].MatAng1.z=Matrix4Float[4,3].x
         Lighting_Lights[iLight].MatAng2.x=Matrix4Float[4,1].y : Lighting_Lights[iLight].MatAng2.y=Matrix4Float[4,2].y : Lighting_Lights[iLight].MatAng2.z=Matrix4Float[4,3].y
         Lighting_Lights[iLight].MatAng3.x=Matrix4Float[4,1].z : Lighting_Lights[iLight].MatAng3.y=Matrix4Float[4,2].z : Lighting_Lights[iLight].MatAng3.z=Matrix4Float[4,3].z
         Set_Vector3(1,0,0,1)
         Transform_Normals_Vector3(1,1,4)
         if iSpotOuterAngle>0
            Lighting_Lights[iLight].Direction.x=-Vector3Float[1].x
            Lighting_Lights[iLight].Direction.y=-Vector3Float[1].y
            Lighting_Lights[iLight].Direction.z=-Vector3Float[1].z
            Lighting_Lights[iLight].Cone.x=1-(iSpotOuterAngle/100)
            Lighting_Lights[iLight].Cone.y=iSpotInnerAngle/100
            Lighting_Lights[iLight].Cone.z=iSpotOuterAngle
            Lighting_Lights[iLight].Cone.w=iSpotInnerAngle
            if Lighting_Lights[iLight].ShadowUpdateAng.x<>round(Lighting_Lights[iLight].Angle.x*8) or Lighting_Lights[iLight].ShadowUpdateAng.y<>round(Lighting_Lights[iLight].Angle.y*8) or Lighting_Lights[iLight].ShadowUpdateAng.z<>round(Lighting_Lights[iLight].Angle.z*8) or Lighting_Lights[iLight].ShadowUpdateAng.w<>round(Lighting_Lights[iLight].Cone.z)
               Lighting_Lights[iLight].ShadowUpdateAng.x=round(Lighting_Lights[iLight].Angle.x*8)
               Lighting_Lights[iLight].ShadowUpdateAng.y=round(Lighting_Lights[iLight].Angle.y*8)
               Lighting_Lights[iLight].ShadowUpdateAng.z=round(Lighting_Lights[iLight].Angle.z*8)
               Lighting_Lights[iLight].ShadowUpdateAng.w=round(Lighting_Lights[iLight].Cone.z)
               Lighting_Lights[iLight].ShadowUpdate=1
            endif
         else
            Lighting_Lights[iLight].Direction.x=0
            Lighting_Lights[iLight].Direction.y=0
            Lighting_Lights[iLight].Direction.z=1
            Lighting_Lights[iLight].Cone.x=0
            Lighting_Lights[iLight].Cone.y=0
            Lighting_Lights[iLight].Cone.z=0
            Lighting_Lights[iLight].Cone.w=0
         endif
         LightUpdate(iLight)
         if Lighting_Lights[iLight].Cone.x>0 then LightMaskUpdate(iLight)
         LightBoundsUpdate(iLight)
      endif
   endif
endfunction

`--------------
` Set Light Texture
`--------------
function LightSetTexture(iLight as integer,iTexture as integer)
   if Lighting_Lights[iLight].InUse=1
      if Lighting_Lights[iLight].Texture<>iTexture
         Lighting_Lights[iLight].Texture=iTexture
         if Lighting_Lights[iLight].Texture=0
            LightsRemovePoint(iLight)
            LightsRemoveSpot(iLight)
         endif
         if Lighting_Lights[iLight].Texture>0
            tPointLight=Lighting_Lights[iLight].PointLight
            if tPointLight>0 then SetObjectImage(Lighting_PointLights[tPointLight].Object,Lighting_Lights[iLight].Texture,1)
            tSpotLight=Lighting_Lights[iLight].SpotLight
            if tSpotLight>0 then SetObjectImage(Lighting_SpotLights[tSpotLight].Object,Lighting_Lights[iLight].Texture,1)
         endif
      endif
   endif
endfunction

`--------------
` Set Light Shadows
`--------------
function LightSetShadow(iLight as integer,iShadow as integer)
   if Lighting_Lights[iLight].InUse=1
      if Lighting_Lights[iLight].Shadows<>iShadow
         Lighting_Lights[iLight].Shadows=iShadow
         LightsRemovePoint(iLight)
         LightsRemoveSpot(iLight)
      endif
   endif
endfunction

`--------------
` Lights Update
`--------------
function LightsUpdate(iTimer as float)

   `Active Lights
      if Lighting_LightsCount>-1
         for l=0 to 32
            tLight=Lighting_LightsActiveFind
            if Lighting_Lights[tLight].InUse=1
               SetVector3(Vector3AGK.x,Lighting_CameraPosition.x-Lighting_Lights[tLight].Offset.x,Lighting_CameraPosition.y-Lighting_Lights[tLight].Offset.y,Lighting_CameraPosition.z-Lighting_Lights[tLight].Offset.z)
               Lighting_Lights[tLight].Dist=GetVector3Length(Vector3AGK.x)
               if Lighting_Lights[tLight].Dist<Lighting_Lights[tLight].CullDist*(1+(Lighting_Lights[tLight].Offset.w*0.01)) and Lighting_Lights[tLight].Visible=1
                  if Lighting_Lights[tLight].Active=0
                     if Lighting_LightsActiveCount=>Lighting_LightsActive.length then Lighting_LightsActive.length=Lighting_LightsActive.length+1
                     inc Lighting_LightsActiveCount : Lighting_LightsActive[Lighting_LightsActiveCount]=tLight+1
                     Lighting_Lights[tLight].Active=Lighting_LightsActiveCount+1
                     LightUpdate(tLight)
                  endif
               else
                  if Lighting_Lights[tLight].Active>0
                     tIndex=Lighting_Lights[tLight].Active-1
                     if tIndex<Lighting_LightsActiveCount
                        tActive=Lighting_LightsActive[Lighting_LightsActiveCount]-1
                        Lighting_Lights[tActive].Active=tIndex+1
                        Lighting_LightsActive[tIndex]=tActive+1
                     endif
                     dec Lighting_LightsActiveCount : Lighting_Lights[tLight].Active=0
                     LightsRemoveArray(tLight)
                     LightsRemovePoint(tLight)
                     LightsRemoveSpot(tLight)
                  endif
               endif
            endif
            inc Lighting_LightsActiveFind
            if Lighting_LightsActiveFind>Lighting_LightsCount 
               Lighting_LightsActiveFind=0
               exit
            endif
         next l
      endif

   `Replace Shadowing Lights
      tSetShadowPoint=-1 : tSetShadowPointDist=0
      tSetShadowSpot=-1 : tSetShadowSpotDist=0
      for x=1 to Lighting_MaxShadows
         if Lighting_ShadowPointLight[x]>0
            tLight=Lighting_ShadowPointLight[x]-1
            if Lighting_Lights[tLight].Shadows=0 or Lighting_Lights[tLight].Active=0 or Lighting_Lights[tLight].InScreen=0 or Lighting_Lights[tLight].Dist>Lighting_Lights[tLight].ShadowCullDist*(1+(Lighting_Lights[tLight].Offset.w*0.01))
               Lighting_Lights[tLight].ShadowPoint=0
               if Lighting_Lights[tLight].Texture=0 then LightsRemovePoint(tLight)
               Lighting_ShadowPointLight[x]=0
               tSetShadowPoint=x   : tSetShadowPointDist=99999999
            endif
            if Lighting_Lights[tLight].Dist/(1+(Lighting_Lights[tLight].Offset.w*0.01))>tSetShadowPointDist 
               tSetShadowPointDist=Lighting_Lights[tLight].Dist/(1+(Lighting_Lights[tLight].Offset.w*0.01))
               tSetShadowPoint=x
            endif
         else
            tSetShadowPoint=x : tSetShadowPointDist=99999999
            exit
         endif
      next x
      for x=1 to Lighting_MaxShadows
         if Lighting_ShadowSpotLight[x]>0
            tLight=Lighting_ShadowSpotLight[x]-1
            if Lighting_Lights[tLight].Shadows=0 or Lighting_Lights[tLight].Active=0 or Lighting_Lights[tLight].InScreen=0 or Lighting_Lights[tLight].Dist>Lighting_Lights[tLight].ShadowCullDist*(1+(Lighting_Lights[tLight].Offset.w*0.01))
               Lighting_Lights[tLight].ShadowSpot=0
               if Lighting_Lights[tLight].Texture=0 then LightsRemoveSpot(tLight)
               Lighting_ShadowSpotLight[x]=0
               tSetShadowSpot=x : tSetShadowSpotDist=99999999
            endif
            if Lighting_Lights[tLight].Dist/(1+(Lighting_Lights[tLight].Offset.w*0.01))>tSetShadowSpotDist 
               tSetShadowSpotDist=Lighting_Lights[tLight].Dist/(1+(Lighting_Lights[tLight].Offset.w*0.01))
               tSetShadowSpot=x
            endif
         else
            tSetShadowSpot=x : tSetShadowSpotDist=99999999
            exit
         endif
      next x

   `Gather Lights In Screen
      tLightRange=0
      Lighting_LightTileRange=0
      Lighting_LightInScreenCount=-1
      tSetPointShadow=-1 : tSetSpotShadow=-1
      for l=0 to Lighting_LightsActiveCount
         tLight=Lighting_LightsActive[l]-1
         Lighting_Lights[tLight].ShadowNear=0
         Lighting_Lights[tLight].InScreen=GetSphereInFrustum(0,Lighting_Lights[tLight].Offset.x,Lighting_Lights[tLight].Offset.y,Lighting_Lights[tLight].Offset.z,Lighting_Lights[tLight].Offset.w)
         if Lighting_Lights[tLight].InScreen=1
            SetVector3(Vector3AGK.x,Lighting_CameraPosition.x-Lighting_Lights[tLight].Offset.x,Lighting_CameraPosition.y-Lighting_Lights[tLight].Offset.y,Lighting_CameraPosition.z-Lighting_Lights[tLight].Offset.z)
            Lighting_Lights[tLight].Dist=GetVector3Length(Vector3AGK.x)
            if Lighting_LightInScreenCount<Lighting_MaxLights
               inc Lighting_LightInScreenCount
               Lighting_LightInScreen[Lighting_LightInScreenCount]=tLight
               if Lighting_Lights[tLight].Dist>Lighting_LightTileRange then Lighting_LightTileRange=Lighting_Lights[tLight].Dist
               if tLightRange<Lighting_Lights[tLight].Range then tLightRange=Lighting_Lights[tLight].Range
               LightsApplyArray(tLight)
               if Lighting_Lights[tLight].Cone.x=0 then LightsApplyPoint(tLight) else LightsApplySpot(tLight)
            endif
            if Lighting_Lights[tLight].Shadows=1 
               if Lighting_Lights[tLight].Dist<Lighting_Lights[tLight].ShadowCullDist*(1+(Lighting_Lights[tLight].Offset.w*0.01))
                  if Lighting_Lights[tLight].Cone.x=0
                     if Lighting_Lights[tLight].ShadowPoint=0
                        if Lighting_Lights[tLight].Dist/(1+(Lighting_Lights[tLight].Offset.w*0.01))<tSetShadowPointDist 
                           tSetPointShadow=tLight
                           tSetShadowPointDist=Lighting_Lights[tLight].Dist/(1+(Lighting_Lights[tLight].Offset.w*0.01))
                        endif
                     endif
                  else
                     if Lighting_Lights[tLight].ShadowSpot=0
                        if Lighting_Lights[tLight].Dist/(1+(Lighting_Lights[tLight].Offset.w*0.01))<tSetShadowSpotDist 
                           tSetSpotShadow=tLight
                           tSetShadowSpotDist=Lighting_Lights[tLight].Dist/(1+(Lighting_Lights[tLight].Offset.w*0.01))
                        endif
                     endif
                  endif
               endif
            endif
         else
            LightsRemoveArray(tLight)
            LightsRemovePoint(tLight)
            LightsRemoveSpot(tLight)
         endif
      next l
      if tLightRange*10>Lighting_LightTileRange then Lighting_LightTileRange=tLightRange*10

   `Update Shadowmaps
      if tSetPointShadow>-1 and tSetShadowPoint>-1
         if Lighting_ShadowPointLight[tSetShadowPoint]>0
            tShadowPointLight=Lighting_ShadowPointLight[tSetShadowPoint]-1
            Lighting_Lights[tShadowPointLight].ShadowPoint=0
            if Lighting_Lights[tShadowPointLight].Texture=0 then LightsRemovePoint(tShadowPointLight)
            LightUpdate(tShadowPointLight)
         endif
         Lighting_ShadowPointLight[tSetShadowPoint]=tSetPointShadow+1
         Lighting_Lights[tSetPointShadow].ShadowPoint=tSetShadowPoint+1
         LightsApplyPoint(tSetPointShadow)
         Lighting_Lights[tSetPointShadow].ShadowUpdate=1
         LightUpdate(tShadowPointLight)
      endif
      if tSetSpotShadow>-1 and tSetShadowSpot>-1
         if Lighting_ShadowSpotLight[tSetShadowSpot]>0
            tShadowSpotLight=Lighting_ShadowSpotLight[tSetShadowSpot]-1
            Lighting_Lights[tShadowSpotLight].ShadowSpot=0
            if Lighting_Lights[tShadowSpotLight].Texture=0 then LightsRemoveSpot(tShadowSpotLight)
            LightUpdate(tShadowSpotLight)
         endif
         Lighting_ShadowSpotLight[tSetShadowSpot]=tSetSpotShadow+1
         Lighting_Lights[tSetSpotShadow].ShadowSpot=tSetShadowSpot+1
         LightsApplySpot(tSetSpotShadow)
         Lighting_Lights[tSetSpotShadow].ShadowUpdate=1
         LightUpdate(tSetSpotShadow)
      endif
      ShadowMapUpdate(iTimer)

   `Update Lighting Masking
      if Lighting_LightUpdateMaskCount>-1
         tLightAssigned=-1
         for l=0 to Lighting_LightInScreenCount
            tLight=Lighting_LightInScreen[l]
            if Lighting_Lights[tLight].PointLight>0 or Lighting_Lights[tLight].SpotLight>0
               inc tLightAssigned
               Lighting_LightAssigned[tLightAssigned]=tLight
            endif
         next l
         for l=0 to Lighting_LightUpdateMaskCount
            tLight=Lighting_LightUpdateMask[l]
            if Lighting_Lights[tLight].MaskUpdate=1
               if Lighting_Lights[tLight].PointLight>0 or Lighting_Lights[tLight].SpotLight>0
                  Lighting_Lights[tLight].MaskUpdate=0
                  Lighting_Lights[tLight].LightUpdate=1
                  if Lighting_Lights[tLight].Masked>0 then dec Lighting_LightMaskCount[Lighting_Lights[tLight].Masked]
                  Lighting_Lights[tLight].Masked=0
                  LightUpdate(tLight)
                  tIntersectionCount=-1
                  for x=0 to tLightAssigned
                     tLight2=Lighting_LightAssigned[x]
                     if tIntersectionCount<16 and tLight<>tLight2
                        Set_Vector3(1,Lighting_Lights[tLight].Offset.x-Lighting_Lights[tLight2].Offset.x,Lighting_Lights[tLight].Offset.y-Lighting_Lights[tLight2].Offset.y,Lighting_Lights[tLight].Offset.z-Lighting_Lights[tLight2].Offset.z)
                        if Length_Vector3(1)<Lighting_Lights[tLight].Offset.w+Lighting_Lights[tLight2].Offset.w
                           inc tIntersectionCount
                           Lighting_LightIntersection[tIntersectionCount]=tLight2
                        endif
                     endif
                  next x
                  if tIntersectionCount>-1
                     tMask=0
                     for i=1 to 6:Lighting_LightMasked[i]=0:next i
                     for x=0 to tIntersectionCount
                        tLight2=Lighting_LightIntersection[x]
                        if Lighting_Lights[tLight2].Masked>0 then Lighting_LightMasked[Lighting_Lights[tLight2].Masked]=1
                     next x
                     for x=1 to 6
                        if Lighting_LightMasked[x]=0 
                           tMask=x
                           exit
                        endif
                     next x
                  else
                     tMask=1
                  endif
                  if tMask>-1
                     inc Lighting_LightMaskCount[tMask]
                     Lighting_Lights[tLight].Masked=tMask
                  endif
               endif
            endif
            Lighting_Lights[tLight].MaskUpdate=0
         next l
         Lighting_LightUpdateMaskCount=-1
      endif

   `Update Lights
      if Lighting_LightUpdateCount>-1
         for l=0 to Lighting_LightUpdateCount
            tLight=Lighting_LightUpdate[l]
            if Lighting_Lights[tLight].LightUpdate=1
               if Lighting_Lights[tLight].LightArray>0
                  tLightArray=Lighting_Lights[tLight].LightArray
                  Vector4F.x=Lighting_Lights[tLight].Cone.y : Vector4F.y=Lighting_Lights[tLight].Cone.x
                  if Lighting_Lights[tLight].Cone.x=0
                     Vector4F.x=0.999
                     Vector4F.y=-100
                  endif
                  for e=0 to Lighting_EffectsCount
                     if Lighting_Effects[e].InUse=1 
                        tEffect=Lighting_Effects[e].Effect
                        SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"LightPosition",tLightArray,Lighting_Lights[tLight].Position.x,Lighting_Lights[tLight].Position.y,Lighting_Lights[tLight].Position.z,Lighting_Lights[tLight].Range)
                        SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"LightColor",tLightArray,(Lighting_Lights[tLight].Color.x/255)^2.2,(Lighting_Lights[tLight].Color.y/255)^2.2,(Lighting_Lights[tLight].Color.z/255)^2.2,Lighting_Lights[tLight].Masked+Vector4F.x)
                        SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"LightSpot",tLightArray,Lighting_Lights[tLight].Direction.x,Lighting_Lights[tLight].Direction.y,Lighting_Lights[tLight].Direction.z,Vector4F.y)
                     endif
                  next e
               endif
               if Lighting_Lights[tLight].PointLight>0
                  tPointLight=Lighting_Lights[tLight].PointLight
                  setobjectposition(Lighting_PointLights[tPointLight].Object,Lighting_Lights[tLight].Offset.x,Lighting_Lights[tLight].Offset.y,Lighting_Lights[tLight].Offset.z)
                  setobjectscale(Lighting_PointLights[tPointLight].Object,Lighting_Lights[tLight].Offset.w/100,Lighting_Lights[tLight].Offset.w/100,Lighting_Lights[tLight].Offset.w/100)
                  Set_Vector4(1,0,0,0,0)
                  if Lighting_Lights[tLight].Masked=3 then Set_Vector4(1,1,0,0,0)
                  if Lighting_Lights[tLight].Masked=4 then Set_Vector4(1,0,1,0,0)
                  if Lighting_Lights[tLight].Masked=1 or Lighting_Lights[tLight].Masked=5 then Set_Vector4(1,0,0,1,0)
                  if Lighting_Lights[tLight].Masked=2 or Lighting_Lights[tLight].Masked=6 then Set_Vector4(1,0,0,0,1)
                  tShader=Lighting_PointLights[tPointLight].Shader
                  tArrayIdx=Lighting_PointLights[tPointLight].Array
                  SetShaderConstantArrayByName(tShader,"LightMask",tArrayIdx,Vector4Float[1].x,Vector4Float[1].y,Vector4Float[1].z,Vector4Float[1].w)
                  SetShaderConstantArrayByName(tShader,"LightPosition",tArrayIdx,Lighting_Lights[tLight].Position.x,Lighting_Lights[tLight].Position.y,Lighting_Lights[tLight].Position.z,Lighting_Lights[tLight].Range)
                  SetShaderConstantArrayVec3ByName(tShader,"LightAng1",tArrayIdx,Lighting_Lights[tLight].MatAng1.x,Lighting_Lights[tLight].MatAng1.y,Lighting_Lights[tLight].MatAng1.z)
                  SetShaderConstantArrayVec3ByName(tShader,"LightAng2",tArrayIdx,Lighting_Lights[tLight].MatAng2.x,Lighting_Lights[tLight].MatAng2.y,Lighting_Lights[tLight].MatAng2.z)
                  SetShaderConstantArrayVec3ByName(tShader,"LightAng3",tArrayIdx,Lighting_Lights[tLight].MatAng3.x,Lighting_Lights[tLight].MatAng3.y,Lighting_Lights[tLight].MatAng3.z)
               endif
               if Lighting_Lights[tLight].SpotLight>0
                  tSpotLight=Lighting_Lights[tLight].SpotLight
                  setobjectposition(Lighting_SpotLights[tSpotLight].Object,Lighting_Lights[tLight].Offset.x,Lighting_Lights[tLight].Offset.y,Lighting_Lights[tLight].Offset.z)
                  setobjectscale(Lighting_SpotLights[tSpotLight].Object,Lighting_Lights[tLight].Offset.w/100,Lighting_Lights[tLight].Offset.w/100,Lighting_Lights[tLight].Offset.w/100)
                  Set_Vector4(1,0,0,0,0)
                  if Lighting_Lights[tLight].Masked=3 then Set_Vector4(1,1,0,0,0)
                  if Lighting_Lights[tLight].Masked=4 then Set_Vector4(1,0,1,0,0)
                  if Lighting_Lights[tLight].Masked=1 or Lighting_Lights[tLight].Masked=5 then Set_Vector4(1,0,0,1,0)
                  if Lighting_Lights[tLight].Masked=2 or Lighting_Lights[tLight].Masked=6 then Set_Vector4(1,0,0,0,1)
                  SetIdentity_Matrix4(1)
                  Matrix4Float[1,1].x=Lighting_Lights[tLight].MatAng1.x : Matrix4Float[1,1].y=Lighting_Lights[tLight].MatAng1.y : Matrix4Float[1,1].z=Lighting_Lights[tLight].MatAng1.z  
                  Matrix4Float[1,2].x=Lighting_Lights[tLight].MatAng2.x : Matrix4Float[1,2].y=Lighting_Lights[tLight].MatAng2.y : Matrix4Float[1,2].z=Lighting_Lights[tLight].MatAng2.z 
                  Matrix4Float[1,3].x=Lighting_Lights[tLight].MatAng3.x : Matrix4Float[1,3].y=Lighting_Lights[tLight].MatAng3.y : Matrix4Float[1,3].z=Lighting_Lights[tLight].MatAng3.z 
                  Translate_Matrix4(2,-Lighting_Lights[tLight].Position.x,-Lighting_Lights[tLight].Position.y,-Lighting_Lights[tLight].Position.z)
                  Multiply_Matrix4(1,2,1)
                  FOV#=htan(((Lighting_Lights[tLight].Cone.z/100)^0.5)*32.5)*325
                  FOV#=1.0/tan(FOV#/2.0)
                  Fill_Matrix4(2,0.0)
                  Matrix4Float[2,1].x=FOV#
                  Matrix4Float[2,2].y=-FOV#
                  Matrix4Float[2,3].z=-1.0/(Lighting_Lights[tLight].Range-1.0)
                  Matrix4Float[2,3].w=1.0
                  Matrix4Float[2,4].z=(Lighting_Lights[tLight].Range-1.0)/Lighting_Lights[tLight].Range
                  Multiply_Matrix4(3,1,2)
                  tShader=Lighting_SpotLights[tSpotLight].Shader
                  tArrayIdx=Lighting_SpotLights[tSpotLight].Array
                  SetShaderConstantArrayByName(tShader,"LightMask",tArrayIdx,Vector4Float[1].x,Vector4Float[1].y,Vector4Float[1].z,Vector4Float[1].w)
                  SetShaderConstantArrayByName(tShader,"LightPosition",tArrayIdx,Lighting_Lights[tLight].Position.x,Lighting_Lights[tLight].Position.y,Lighting_Lights[tLight].Position.z,Lighting_Lights[tLight].Range)
                  SetShaderConstantArrayByName(tShader,"LightSpot",tArrayIdx,Lighting_Lights[tLight].Direction.x,Lighting_Lights[tLight].Direction.y,Lighting_Lights[tLight].Direction.z,Lighting_Lights[tLight].Cone.x)
                  SetShaderConstantArrayByName(tShader,"LightProj1",tArrayIdx,Matrix4Float[3,1].x,Matrix4Float[3,1].y,Matrix4Float[3,1].z,Matrix4Float[3,1].w)
                  SetShaderConstantArrayByName(tShader,"LightProj2",tArrayIdx,Matrix4Float[3,2].x,Matrix4Float[3,2].y,Matrix4Float[3,2].z,Matrix4Float[3,2].w)
                  SetShaderConstantArrayByName(tShader,"LightProj3",tArrayIdx,Matrix4Float[3,3].x,Matrix4Float[3,3].y,Matrix4Float[3,3].z,Matrix4Float[3,3].w)
                  SetShaderConstantArrayByName(tShader,"LightProj4",tArrayIdx,Matrix4Float[3,4].x,Matrix4Float[3,4].y,Matrix4Float[3,4].z,Matrix4Float[3,4].w)
               endif
            endif
            Lighting_Lights[tLight].LightUpdate=0
         next l
         Lighting_LightUpdateCount=-1
      endif

   `Screen X/Y Dividers
      Vector4F.z=2.0*atan(tan(Lighting_CameraData.z*0.5)/Lighting_CameraData.w)
      Vector4F.z=tan(Vector4F.z/2.0)
      Vector4F.w=Vector4F.z*Lighting_CameraData.w
      for x=1 to 3
         Vector4F.x=x-2
         Set_Vector3(1,Vector4F.w*(Vector4F.x/2),0,1)
         Transform_Coords_vector3(1,1,202)
         Set_Vector3(2,Vector4F.w*(Vector4F.x/2),Vector4F.z,1)
         Transform_Coords_vector3(2,2,202)
         SetVector3(Vector3AGK.x,Vector3Float[1].x-Lighting_CameraPosition.x,Vector3Float[1].y-Lighting_CameraPosition.y,Vector3Float[1].z-Lighting_CameraPosition.z)
         SetVector3(Vector3AGK.y,Vector3Float[2].x-Lighting_CameraPosition.x,Vector3Float[2].y-Lighting_CameraPosition.y,Vector3Float[2].z-Lighting_CameraPosition.z)
         GetVector3Cross(Vector3AGK.z,Vector3AGK.x,Vector3AGK.y)
         tDist#=GetVector3Length(Vector3AGK.z)
         Lighting_LightTileClipX[x].x=-GetVector3X(Vector3AGK.z)/tDist#
         Lighting_LightTileClipX[x].y=-GetVector3Y(Vector3AGK.z)/tDist#
         Lighting_LightTileClipX[x].z=-GetVector3Z(Vector3AGK.z)/tDist#
         Set_Vector3(1,0,Vector4F.z*(Vector4F.x/2),1)
         Transform_Coords_vector3(1,1,202)
         Set_Vector3(2,Vector4F.w,Vector4F.z*(Vector4F.x/2),1)
         Transform_Coords_vector3(2,2,202)
         SetVector3(Vector3AGK.x,Vector3Float[1].x-Lighting_CameraPosition.x,Vector3Float[1].y-Lighting_CameraPosition.y,Vector3Float[1].z-Lighting_CameraPosition.z)
         SetVector3(Vector3AGK.y,Vector3Float[2].x-Lighting_CameraPosition.x,Vector3Float[2].y-Lighting_CameraPosition.y,Vector3Float[2].z-Lighting_CameraPosition.z)
         GetVector3Cross(Vector3AGK.z,Vector3AGK.x,Vector3AGK.y)
         tDist#=GetVector3Length(Vector3AGK.z)
         Lighting_LightTileClipY[x].x=-GetVector3X(Vector3AGK.z)/tDist#
         Lighting_LightTileClipY[x].y=-GetVector3Y(Vector3AGK.z)/tDist#
         Lighting_LightTileClipY[x].z=-GetVector3Z(Vector3AGK.z)/tDist#
      next x

   `Update Lights Inscreen
      Lighting_PointLightDrawCount1=-1 : Lighting_SpotLightDrawCount1=-1
      Lighting_PointLightDrawCount2=-1 : Lighting_SpotLightDrawCount2=-1
      for l=0 to Lighting_LightInScreenCount
         tLight=Lighting_LightInScreen[l]

      `Draw Light Mask Array
         if Lighting_Lights[tLight].PointLight>0
            tPointLight=Lighting_Lights[tLight].PointLight
            if Lighting_Lights[tLight].Masked>2
               inc Lighting_PointLightDrawCount2
               Lighting_PointLightDraw2[Lighting_PointLightDrawCount2]=Lighting_PointLights[tPointLight].Object
            else
               if Lighting_Lights[tLight].Masked>0
                  inc Lighting_PointLightDrawCount1
                  Lighting_PointLightDraw1[Lighting_PointLightDrawCount1]=Lighting_PointLights[tPointLight].Object
               endif
            endif
         endif
         if Lighting_Lights[tLight].SpotLight>0
            tSpotLight=Lighting_Lights[tLight].SpotLight
            if Lighting_Lights[tLight].Masked>2
              inc Lighting_SpotLightDrawCount2
              Lighting_SpotLightDraw2[Lighting_SpotLightDrawCount2]=Lighting_SpotLights[tSpotLight].Object
            else
              if Lighting_Lights[tLight].Masked>0
                 inc Lighting_SpotLightDrawCount1
                 Lighting_SpotLightDraw1[Lighting_SpotLightDrawCount1]=Lighting_SpotLights[tSpotLight].Object
              endif
            endif
         endif

      `Assign Lights To Screen Tiles
         if Lighting_Lights[tLight].LightArray>0 
            Vector4F.x=Lighting_CameraPosition.x-Lighting_Lights[tLight].Offset.x
            Vector4F.y=Lighting_CameraPosition.y-Lighting_Lights[tLight].Offset.y
            Vector4F.z=Lighting_CameraPosition.z-Lighting_Lights[tLight].Offset.z
            Vector4F.w=Lighting_Lights[tLight].Offset.w
            tMin#=(Lighting_Lights[tLight].Dist-(Vector4F.w+2))/(Lighting_LightTileRange*0.25)
            tMax#=(Lighting_Lights[tLight].Dist+(Vector4F.w+2))/(Lighting_LightTileRange*0.25)
            tMin=floor(tMin#) : tMax=floor(tMax#)
            if tMin<0 then tMin=0
            if tMin>3 then tMin=3
            if tMax<0 then tMax=0
            if tMax>3 then tMax=3
            Lighting_LightTileClipX[1].w=Lighting_LightTileClipX[1].x*Vector4F.x+Lighting_LightTileClipX[1].y*Vector4F.y+Lighting_LightTileClipX[1].z*Vector4F.z
            Lighting_LightTileClipX[2].w=Lighting_LightTileClipX[2].x*Vector4F.x+Lighting_LightTileClipX[2].y*Vector4F.y+Lighting_LightTileClipX[2].z*Vector4F.z
            Lighting_LightTileClipX[3].w=Lighting_LightTileClipX[3].x*Vector4F.x+Lighting_LightTileClipX[3].y*Vector4F.y+Lighting_LightTileClipX[3].z*Vector4F.z
            Lighting_LightTileClipY[1].w=Lighting_LightTileClipY[1].x*Vector4F.x+Lighting_LightTileClipY[1].y*Vector4F.y+Lighting_LightTileClipY[1].z*Vector4F.z
            Lighting_LightTileClipY[2].w=Lighting_LightTileClipY[2].x*Vector4F.x+Lighting_LightTileClipY[2].y*Vector4F.y+Lighting_LightTileClipY[2].z*Vector4F.z
            Lighting_LightTileClipY[3].w=Lighting_LightTileClipY[3].x*Vector4F.x+Lighting_LightTileClipY[3].y*Vector4F.y+Lighting_LightTileClipY[3].z*Vector4F.z
            if tMin<>tMax
               if Lighting_LightTileClipX[2].w<Vector4F.w and Lighting_LightTileClipY[2].w<Vector4F.w
                  if Lighting_LightTileClipX[1].w<Vector4F.w and Lighting_LightTileClipY[3].w<Vector4F.w
                     inc Lighting_LightTileCount[0,0,tMin]
                     Lighting_LightTileLight[0,0,tMin,Lighting_LightTileCount[0,0,tMin]]=Lighting_Lights[tLight].LightArray
                     inc Lighting_LightTileCount[0,0,tMax]
                     Lighting_LightTileLight[0,0,tMax,Lighting_LightTileCount[0,0,tMax]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[1].w>-Vector4F.w and Lighting_LightTileClipY[3].w<Vector4F.w
                     inc Lighting_LightTileCount[1,0,tMin]
                     Lighting_LightTileLight[1,0,tMin,Lighting_LightTileCount[1,0,tMin]]=Lighting_Lights[tLight].LightArray
                     inc Lighting_LightTileCount[1,0,tMax]
                     Lighting_LightTileLight[1,0,tMax,Lighting_LightTileCount[1,0,tMax]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[1].w<Vector4F.w and Lighting_LightTileClipY[3].w>-Vector4F.w
                     inc Lighting_LightTileCount[0,1,tMin]
                     Lighting_LightTileLight[0,1,tMin,Lighting_LightTileCount[0,1,tMin]]=Lighting_Lights[tLight].LightArray
                     inc Lighting_LightTileCount[0,1,tMax]
                     Lighting_LightTileLight[0,1,tMax,Lighting_LightTileCount[0,1,tMax]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[1].w>-Vector4F.w and Lighting_LightTileClipY[3].w>-Vector4F.w
                     inc Lighting_LightTileCount[1,1,tMin]
                     Lighting_LightTileLight[1,1,tMin,Lighting_LightTileCount[1,1,tMin]]=Lighting_Lights[tLight].LightArray
                     inc Lighting_LightTileCount[1,1,tMax]
                     Lighting_LightTileLight[1,1,tMax,Lighting_LightTileCount[1,1,tMax]]=Lighting_Lights[tLight].LightArray
                  endif
               endif
               if Lighting_LightTileClipX[2].w>-Vector4F.w and Lighting_LightTileClipY[2].w<Vector4F.w
                  if Lighting_LightTileClipX[3].w<Vector4F.w and Lighting_LightTileClipY[3].w<Vector4F.w
                     inc Lighting_LightTileCount[2,0,tMin]
                     Lighting_LightTileLight[2,0,tMin,Lighting_LightTileCount[2,0,tMin]]=Lighting_Lights[tLight].LightArray
                     inc Lighting_LightTileCount[2,0,tMax]
                     Lighting_LightTileLight[2,0,tMax,Lighting_LightTileCount[2,0,tMax]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[3].w>-Vector4F.w and Lighting_LightTileClipY[3].w<Vector4F.w
                     inc Lighting_LightTileCount[3,0,tMin]
                     Lighting_LightTileLight[3,0,tMin,Lighting_LightTileCount[3,0,tMin]]=Lighting_Lights[tLight].LightArray
                     inc Lighting_LightTileCount[3,0,tMax]
                     Lighting_LightTileLight[3,0,tMax,Lighting_LightTileCount[3,0,tMax]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[3].w<Vector4F.w and Lighting_LightTileClipY[3].w>-Vector4F.w
                     inc Lighting_LightTileCount[2,1,tMin]
                     Lighting_LightTileLight[2,1,tMin,Lighting_LightTileCount[2,1,tMin]]=Lighting_Lights[tLight].LightArray
                     inc Lighting_LightTileCount[2,1,tMax]
                     Lighting_LightTileLight[2,1,tMax,Lighting_LightTileCount[2,1,tMax]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[3].w>-Vector4F.w and Lighting_LightTileClipY[3].w>-Vector4F.w
                     inc Lighting_LightTileCount[3,1,tMin]
                     Lighting_LightTileLight[3,1,tMin,Lighting_LightTileCount[3,1,tMin]]=Lighting_Lights[tLight].LightArray
                     inc Lighting_LightTileCount[3,1,tMax]
                     Lighting_LightTileLight[3,1,tMax,Lighting_LightTileCount[3,1,tMax]]=Lighting_Lights[tLight].LightArray
                  endif
               endif
               if Lighting_LightTileClipX[2].w<Vector4F.w and Lighting_LightTileClipY[2].w>-Vector4F.w
                  if Lighting_LightTileClipX[1].w<Vector4F.w and Lighting_LightTileClipY[1].w<Vector4F.w
                     inc Lighting_LightTileCount[0,2,tMin]
                     Lighting_LightTileLight[0,2,tMin,Lighting_LightTileCount[0,2,tMin]]=Lighting_Lights[tLight].LightArray
                     inc Lighting_LightTileCount[0,2,tMax]
                     Lighting_LightTileLight[0,2,tMax,Lighting_LightTileCount[0,2,tMax]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[1].w>-Vector4F.w and Lighting_LightTileClipY[1].w<Vector4F.w
                     inc Lighting_LightTileCount[1,2,tMin]
                     Lighting_LightTileLight[1,2,tMin,Lighting_LightTileCount[1,2,tMin]]=Lighting_Lights[tLight].LightArray
                     inc Lighting_LightTileCount[1,2,tMax]
                     Lighting_LightTileLight[1,2,tMax,Lighting_LightTileCount[1,2,tMax]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[1].w<Vector4F.w and Lighting_LightTileClipY[1].w>-Vector4F.w
                     inc Lighting_LightTileCount[0,3,tMin]
                     Lighting_LightTileLight[0,3,tMin,Lighting_LightTileCount[0,3,tMin]]=Lighting_Lights[tLight].LightArray
                     inc Lighting_LightTileCount[0,3,tMax]
                     Lighting_LightTileLight[0,3,tMax,Lighting_LightTileCount[0,3,tMax]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[1].w>-Vector4F.w and Lighting_LightTileClipY[1].w>-Vector4F.w
                     inc Lighting_LightTileCount[1,3,tMin]
                     Lighting_LightTileLight[1,3,tMin,Lighting_LightTileCount[1,3,tMin]]=Lighting_Lights[tLight].LightArray
                     inc Lighting_LightTileCount[1,3,tMax]
                     Lighting_LightTileLight[1,3,tMax,Lighting_LightTileCount[1,3,tMax]]=Lighting_Lights[tLight].LightArray
                  endif
               endif
               if Lighting_LightTileClipX[2].w>-Vector4F.w and Lighting_LightTileClipY[2].w>-Vector4F.w
                  if Lighting_LightTileClipX[3].w<Vector4F.w and Lighting_LightTileClipY[1].w<Vector4F.w
                     inc Lighting_LightTileCount[2,2,tMin]
                     Lighting_LightTileLight[2,2,tMin,Lighting_LightTileCount[2,2,tMin]]=Lighting_Lights[tLight].LightArray
                     inc Lighting_LightTileCount[2,2,tMax]
                     Lighting_LightTileLight[2,2,tMax,Lighting_LightTileCount[2,2,tMax]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[3].w>-Vector4F.w and Lighting_LightTileClipY[1].w<Vector4F.w
                     inc Lighting_LightTileCount[3,2,tMin]
                     Lighting_LightTileLight[3,2,tMin,Lighting_LightTileCount[3,2,tMin]]=Lighting_Lights[tLight].LightArray
                     inc Lighting_LightTileCount[3,2,tMax]
                     Lighting_LightTileLight[3,2,tMax,Lighting_LightTileCount[3,2,tMax]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[3].w<Vector4F.w and Lighting_LightTileClipY[1].w>-Vector4F.w
                     inc Lighting_LightTileCount[2,3,tMin]
                     Lighting_LightTileLight[2,3,tMin,Lighting_LightTileCount[2,3,tMin]]=Lighting_Lights[tLight].LightArray
                     inc Lighting_LightTileCount[2,3,tMax]
                     Lighting_LightTileLight[2,3,tMax,Lighting_LightTileCount[2,3,tMax]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[3].w>-Vector4F.w and Lighting_LightTileClipY[1].w>-Vector4F.w
                     inc Lighting_LightTileCount[3,3,tMin]
                     Lighting_LightTileLight[3,3,tMin,Lighting_LightTileCount[3,3,tMin]]=Lighting_Lights[tLight].LightArray
                     inc Lighting_LightTileCount[3,3,tMax]
                     Lighting_LightTileLight[3,3,tMax,Lighting_LightTileCount[3,3,tMax]]=Lighting_Lights[tLight].LightArray
                  endif
               endif
            else
               if Lighting_LightTileClipX[2].w<Vector4F.w and Lighting_LightTileClipY[2].w<Vector4F.w
                  if Lighting_LightTileClipX[1].w<Vector4F.w and Lighting_LightTileClipY[3].w<Vector4F.w
                     inc Lighting_LightTileCount[0,0,tMin]
                     Lighting_LightTileLight[0,0,tMin,Lighting_LightTileCount[0,0,tMin]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[1].w>-Vector4F.w and Lighting_LightTileClipY[3].w<Vector4F.w
                     inc Lighting_LightTileCount[1,0,tMin]
                     Lighting_LightTileLight[1,0,tMin,Lighting_LightTileCount[1,0,tMin]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[1].w<Vector4F.w and Lighting_LightTileClipY[3].w>-Vector4F.w
                     inc Lighting_LightTileCount[0,1,tMin]
                     Lighting_LightTileLight[0,1,tMin,Lighting_LightTileCount[0,1,tMin]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[1].w>-Vector4F.w and Lighting_LightTileClipY[3].w>-Vector4F.w
                     inc Lighting_LightTileCount[1,1,tMin]
                     Lighting_LightTileLight[1,1,tMin,Lighting_LightTileCount[1,1,tMin]]=Lighting_Lights[tLight].LightArray
                  endif
               endif
               if Lighting_LightTileClipX[2].w>-Vector4F.w and Lighting_LightTileClipY[2].w<Vector4F.w
                  if Lighting_LightTileClipX[3].w<Vector4F.w and Lighting_LightTileClipY[3].w<Vector4F.w
                     inc Lighting_LightTileCount[2,0,tMin]
                     Lighting_LightTileLight[2,0,tMin,Lighting_LightTileCount[2,0,tMin]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[3].w>-Vector4F.w and Lighting_LightTileClipY[3].w<Vector4F.w
                     inc Lighting_LightTileCount[3,0,tMin]
                     Lighting_LightTileLight[3,0,tMin,Lighting_LightTileCount[3,0,tMin]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[3].w<Vector4F.w and Lighting_LightTileClipY[3].w>-Vector4F.w
                     inc Lighting_LightTileCount[2,1,tMin]           
                     Lighting_LightTileLight[2,1,tMin,Lighting_LightTileCount[2,1,tMin]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[3].w>-Vector4F.w and Lighting_LightTileClipY[3].w>-Vector4F.w
                     inc Lighting_LightTileCount[3,1,tMin]
                     Lighting_LightTileLight[3,1,tMin,Lighting_LightTileCount[3,1,tMin]]=Lighting_Lights[tLight].LightArray
                  endif
               endif
               if Lighting_LightTileClipX[2].w<Vector4F.w and Lighting_LightTileClipY[2].w>-Vector4F.w
                  if Lighting_LightTileClipX[1].w<Vector4F.w and Lighting_LightTileClipY[1].w<Vector4F.w
                     inc Lighting_LightTileCount[0,2,tMin]
                     Lighting_LightTileLight[0,2,tMin,Lighting_LightTileCount[0,2,tMin]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[1].w>-Vector4F.w and Lighting_LightTileClipY[1].w<Vector4F.w
                     inc Lighting_LightTileCount[1,2,tMin]
                     Lighting_LightTileLight[1,2,tMin,Lighting_LightTileCount[1,2,tMin]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[1].w<Vector4F.w and Lighting_LightTileClipY[1].w>-Vector4F.w
                     inc Lighting_LightTileCount[0,3,tMin]
                     Lighting_LightTileLight[0,3,tMin,Lighting_LightTileCount[0,3,tMin]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[1].w>-Vector4F.w and Lighting_LightTileClipY[1].w>-Vector4F.w
                     inc Lighting_LightTileCount[1,3,tMin]
                     Lighting_LightTileLight[1,3,tMin,Lighting_LightTileCount[1,3,tMin]]=Lighting_Lights[tLight].LightArray
                  endif
               endif
               if Lighting_LightTileClipX[2].w>-Vector4F.w and Lighting_LightTileClipY[2].w>-Vector4F.w
                  if Lighting_LightTileClipX[3].w<Vector4F.w and Lighting_LightTileClipY[1].w<Vector4F.w
                     inc Lighting_LightTileCount[2,2,tMin]
                     Lighting_LightTileLight[2,2,tMin,Lighting_LightTileCount[2,2,tMin]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[3].w>-Vector4F.w and Lighting_LightTileClipY[1].w<Vector4F.w
                     inc Lighting_LightTileCount[3,2,tMin]
                     Lighting_LightTileLight[3,2,tMin,Lighting_LightTileCount[3,2,tMin]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[3].w<Vector4F.w and Lighting_LightTileClipY[1].w>-Vector4F.w
                     inc Lighting_LightTileCount[2,3,tMin]
                     Lighting_LightTileLight[2,3,tMin,Lighting_LightTileCount[2,3,tMin]]=Lighting_Lights[tLight].LightArray
                  endif
                  if Lighting_LightTileClipX[3].w>-Vector4F.w and Lighting_LightTileClipY[1].w>-Vector4F.w
                     inc Lighting_LightTileCount[3,3,tMin]
                     Lighting_LightTileLight[3,3,tMin,Lighting_LightTileCount[3,3,tMin]]=Lighting_Lights[tLight].LightArray
                  endif
               endif
            endif
         endif

     next l

   `Update Light Tile Data      
      tTileEffect=Lighting_LightTileEffect[1]
      for x=0 to 3
         for y=0 to 3
            if Lighting_LightTileCount[x,y,0]>49 then Lighting_LightTileCount[x,y,0]=49
            if Lighting_LightTileCount[x,y,1]>49 then Lighting_LightTileCount[x,y,1]=49
            if Lighting_LightTileCount[x,y,2]>49 then Lighting_LightTileCount[x,y,2]=49
            if Lighting_LightTileCount[x,y,3]>49 then Lighting_LightTileCount[x,y,3]=49
            tMax=Lighting_LightTileCount[x,y,0]
            if Lighting_LightTileCount[x,y,1]>tMax then tMax=Lighting_LightTileCount[x,y,1]
            if Lighting_LightTileCount[x,y,2]>tMax then tMax=Lighting_LightTileCount[x,y,2]
            if Lighting_LightTileCount[x,y,3]>tMax then tMax=Lighting_LightTileCount[x,y,3]
            SetShaderConstantArrayByName(Effects[tTileEffect].Shader[0],"pColor",x+(y*50),1+Lighting_LightTileCount[x,y,0],1+Lighting_LightTileCount[x,y,1],1+Lighting_LightTileCount[x,y,2],1+Lighting_LightTileCount[x,y,3])
            tPos=(4+x+(y*4))*50
            for l=0 to tMax
               SetShaderConstantArrayByName(Effects[tTileEffect].Shader[0],"pColor",l+tPos,Lighting_LightTileLight[x,y,0,l],Lighting_LightTileLight[x,y,1,l],Lighting_LightTileLight[x,y,2,l],Lighting_LightTileLight[x,y,3,l])
            next l
            Lighting_LightTileCount[x,y,0]=-1 : Lighting_LightTileCount[x,y,1]=-1
            Lighting_LightTileCount[x,y,2]=-1 : Lighting_LightTileCount[x,y,3]=-1
         next y
      next x

endfunction

`--------------
` Light Update
`--------------
function LightUpdate(iLight as integer)
   if Lighting_Lights[iLight].LightUpdate=0
      Lighting_Lights[iLight].LightUpdate=1
      inc Lighting_LightUpdateCount
      Lighting_LightUpdate[Lighting_LightUpdateCount]=iLight
   endif
endfunction

`--------------
` Light Mask Update
`--------------
function LightMaskUpdate(iLight as integer)
   if Lighting_Lights[iLight].MaskUpdate=0
      Lighting_Lights[iLight].MaskUpdate=1
      inc Lighting_LightUpdateMaskCount
      Lighting_LightUpdateMask[Lighting_LightUpdateMaskCount]=iLight
   endif
endfunction

`--------------
` Light Bounds Update
`--------------
function LightBoundsUpdate(iLight as integer)
   if Lighting_Lights[iLight].Cone.x=0
      Lighting_Lights[iLight].Offset.x=Lighting_Lights[iLight].Position.x
      Lighting_Lights[iLight].Offset.y=Lighting_Lights[iLight].Position.y
      Lighting_Lights[iLight].Offset.z=Lighting_Lights[iLight].Position.z
      Lighting_Lights[iLight].Offset.w=Lighting_Lights[iLight].Range
   else
      Vector4F.w=Lighting_Lights[iLight].Cone.x
      if Vector4F.w<0 then Vector4F.w=0
      Lighting_Lights[iLight].Offset.x=Lighting_Lights[iLight].Position.x+(-Lighting_Lights[iLight].Direction.x*(Lighting_Lights[iLight].Range*0.5)*(Vector4F.w^0.25))
      Lighting_Lights[iLight].Offset.y=Lighting_Lights[iLight].Position.y+(-Lighting_Lights[iLight].Direction.y*(Lighting_Lights[iLight].Range*0.5)*(Vector4F.w^0.25))
      Lighting_Lights[iLight].Offset.z=Lighting_Lights[iLight].Position.z+(-Lighting_Lights[iLight].Direction.z*(Lighting_Lights[iLight].Range*0.5)*(Vector4F.w^0.25))
      Lighting_Lights[iLight].Offset.w=Lighting_Lights[iLight].Range*0.5*(1+((1-Vector4F.w)^0.5))
   endif
endfunction

`--------------
` Apply Light Array
`--------------
function LightsApplyArray(iLight as integer)
   if Lighting_Lights[iLight].LightArray=0
      tLightArray=-1
      for x=Lighting_LightArrayFreeUp to Lighting_MaxLights
         if Lighting_LightArray[x].InUse=0 
            tLightArray=x
            exit
         endif
      next x
      if tLightArray>-1
         Lighting_LightArrayFreeUp=tLightArray 
         Lighting_Lights[iLight].LightArray=tLightArray
         Lighting_LightArray[tLightArray].InUse=1
         LightUpdate(iLight)
      endif
   endif
endfunction

`--------------
` Remove Light Array
`--------------
function LightsRemoveArray(iLight as integer)
   if Lighting_Lights[iLight].LightArray>0
      tLightArray=Lighting_Lights[iLight].LightArray
      Lighting_LightArray[tLightArray].InUse=0
      if Lighting_LightArrayFreeUp>tLightArray then Lighting_LightArrayFreeUp=tLightArray
      Lighting_Lights[iLight].LightArray=0
   endif
endfunction

`--------------
` Apply Point Light
`--------------
function LightsApplyPoint(iLight as integer)
   if Lighting_Lights[iLight].Texture>0 or Lighting_Lights[iLight].ShadowPoint>0
      if Lighting_Lights[iLight].PointLight=0
         tPointLight=-1
         for x=Lighting_PointLightFreeUp to Lighting_MaxLights
            if Lighting_PointLights[x].InUse=0 
               tPointLight=x
               exit
            endif
         next x
         if tPointLight>-1
            LightUpdate(iLight)
            LightMaskUpdate(iLight)
            tIndex=tPointLight/60
            Lighting_PointLightFreeUp=tPointLight
            Lighting_Lights[iLight].PointLight=tPointLight
            Lighting_PointLights[tPointLight].InUse=1
            Lighting_PointLights[tPointLight].Array=tPointLight-(tIndex*60)
            if Lighting_PointLightEfects[tIndex,0]=0
               Lighting_PointLightEfects[tIndex,0]=CreateEffect()
               LoadEffectTechnique(Lighting_PointLightEfects[tIndex,0],"0","Shaders\Lighting\Point\Point.vs","Shaders\Lighting\Point\Point0.ps")
               if Lighting_PointLightEfectsCount<tIndex then Lighting_PointLightEfectsCount=tIndex
            endif
            if Lighting_PointLights[tPointLight].Object=0
               tEffect=Lighting_PointLightEfects[tIndex,0]
               Lighting_PointLights[tPointLight].Object=FreeUpObject(35000+random(0,35000))
               CreateObjectSphere(Lighting_PointLights[tPointLight].Object,-210,10,10)
               SetObjectColor(Lighting_PointLights[tPointLight].Object,(Lighting_PointLights[tPointLight].Array*255)+0.01,0,0,0)
               SetObjectImage(Lighting_PointLights[tPointLight].Object,Lighting_Image[1],0)
               SetObjectTransparency(Lighting_PointLights[tPointLight].Object,3)
               SetObjectBlendModes(Lighting_PointLights[tPointLight].Object,1,1)
               SetObjectDepthWrite(Lighting_PointLights[tPointLight].Object,0)
               SetObjectDepthReadMode(Lighting_PointLights[tPointLight].Object,7)
               setobjectvisible(Lighting_PointLights[tPointLight].Object,0)
               SetObjectEffect(Lighting_PointLights[tPointLight].Object,tEffect,0)
               Lighting_PointLights[tPointLight].Effect=tEffect
               Lighting_PointLights[tPointLight].Shader=Effects[tEffect].Shader[0]
               Lighting_PointLights[tPointLight].ShaderMode=0
            endif
            if Lighting_Lights[iLight].Texture>0 then SetObjectImage(Lighting_PointLights[tPointLight].Object,Lighting_Lights[iLight].Texture,1)
         endif
      endif
   endif
   if Lighting_Lights[iLight].PointLight>0
      tPointLight=Lighting_Lights[iLight].PointLight
      tIndex=tPointLight/60
      tEffect=Lighting_PointLightEfects[tIndex,0]
      tShaderMode=0
      if Lighting_Lights[iLight].ShadowPoint>0
         tShaderMode=1
         if Lighting_ShadowsQuality>0 and Lighting_Lights[iLight].Dist<Lighting_Lights[iLight].Offset.w*1.25 then tShaderMode=2
         if Lighting_Lights[iLight].Texture>0 then inc tShaderMode,2
      endif
      if Lighting_PointLights[tPointLight].ShaderMode<>tShaderMode
         if Lighting_PointLightEfects[tIndex,tShaderMode]=0
            LoadEffectTechnique(tEffect,str(tShaderMode),"Shaders\Lighting\Point\Point.vs","Shaders\Lighting\Point\Point"+str(tShaderMode)+".ps")
            Lighting_PointLightEfects[tIndex,tShaderMode]=Effects[tEffect].ShaderCount
         endif
         Lighting_PointLights[tPointLight].ShaderMode=tShaderMode
         tShader=0
         if tShaderMode>0 then tShader=Lighting_PointLightEfects[tIndex,tShaderMode]
         Lighting_PointLights[tPointLight].Shader=Effects[tEffect].Shader[tShader]
         SetObjectShader(Lighting_PointLights[tPointLight].Object,Lighting_PointLights[tPointLight].Shader)
         LightUpdate(iLight)
      endif
   endif
endfunction

`--------------
` Remove Point Light
`--------------
function LightsRemovePoint(iLight as integer)
   if Lighting_Lights[iLight].PointLight>0
      tPointLight=Lighting_Lights[iLight].PointLight
      Lighting_PointLights[tPointLight].InUse=0
      if Lighting_PointLightFreeUp>tPointLight then Lighting_PointLightFreeUp=tPointLight
      Lighting_Lights[iLight].PointLight=0     
      if Lighting_Lights[iLight].ShadowPoint>0 
         Lighting_ShadowPointLight[Lighting_Lights[iLight].ShadowPoint-1]=0
         Lighting_Lights[iLight].ShadowPoint=0
      endif
      if Lighting_Lights[iLight].Masked>0 then dec Lighting_LightMaskCount[Lighting_Lights[iLight].Masked]
      Lighting_Lights[iLight].Masked=0
      LightUpdate(iLight)
   endif
endfunction

`--------------
` Apply Spot Light
`--------------
function LightsApplySpot(iLight as integer)
   if Lighting_Lights[iLight].Texture>0 or Lighting_Lights[iLight].ShadowSpot>0
      if Lighting_Lights[iLight].SpotLight=0
         tSpotLight=-1
         for x=Lighting_SpotLightFreeUp to Lighting_MaxLights
            if Lighting_SpotLights[x].InUse=0 
               tSpotLight=x
               exit
            endif
         next x
         if tSpotLight>-1
            LightUpdate(iLight)
            LightMaskUpdate(iLight)
            tIndex=tSpotLight/60
            Lighting_SpotLightFreeUp=tSpotLight
            Lighting_Lights[iLight].SpotLight=tSpotLight
            Lighting_SpotLights[tSpotLight].InUse=1
            Lighting_SpotLights[tSpotLight].Array=tSpotLight-(tIndex*60)
            if Lighting_SpotLightEfects[tIndex,0]=0
               Lighting_SpotLightEfects[tIndex,0]=CreateEffect()
               LoadEffectTechnique(Lighting_SpotLightEfects[tIndex,0],"0","Shaders\Lighting\Spot\Spot.vs","Shaders\Lighting\Spot\Spot0.ps")
               if Lighting_SpotLightEfectsCount<tIndex then Lighting_SpotLightEfectsCount=tIndex
            endif
            if Lighting_SpotLights[tSpotLight].Object=0
               tEffect=Lighting_SpotLightEfects[tIndex,0]
               Lighting_SpotLights[tSpotLight].Object=FreeUpObject(35000+random(0,35000))
               CreateObjectSphere(Lighting_SpotLights[tSpotLight].Object,-210,10,10)
               SetObjectColor(Lighting_SpotLights[tSpotLight].Object,(Lighting_SpotLights[tSpotLight].Array*255)+0.01,0,0,0)
               SetObjectImage(Lighting_SpotLights[tSpotLight].Object,Lighting_Image[1],0)
               SetObjectTransparency(Lighting_SpotLights[tSpotLight].Object,3)
               SetObjectBlendModes(Lighting_SpotLights[tSpotLight].Object,1,1)
               SetObjectDepthWrite(Lighting_SpotLights[tSpotLight].Object,0)
               SetObjectDepthReadMode(Lighting_SpotLights[tSpotLight].Object,7)
               setobjectvisible(Lighting_SpotLights[tSpotLight].Object,0)
               SetObjectEffect(Lighting_SpotLights[tSpotLight].Object,tEffect,0)
               Lighting_SpotLights[tSpotLight].Effect=tEffect
               Lighting_SpotLights[tSpotLight].Shader=Effects[tEffect].Shader[0]
            endif
            if Lighting_Lights[iLight].Texture>0 then SetObjectImage(Lighting_SpotLights[tSpotLight].Object,Lighting_Lights[iLight].Texture,1)
         endif
      endif
   endif
   if Lighting_Lights[iLight].SpotLight>0
      tSpotLight=Lighting_Lights[iLight].SpotLight
      tIndex=tSpotLight/60
      tEffect=Lighting_SpotLightEfects[tIndex,0]
      tShaderMode=0
      if Lighting_Lights[iLight].ShadowSpot>0
         tShaderMode=1
         if Lighting_ShadowsQuality>0 and Lighting_Lights[iLight].Dist<Lighting_Lights[iLight].Offset.w*1.25 then tShaderMode=2
         if Lighting_Lights[iLight].Texture>0 then inc tShaderMode,2
      endif
      if Lighting_SpotLights[tSpotLight].ShaderMode<>tShaderMode
         if Lighting_SpotLightEfects[tIndex,tShaderMode]=0
            LoadEffectTechnique(tEffect,str(tShaderMode),"Shaders\Lighting\Spot\Spot.vs","Shaders\Lighting\Spot\Spot"+str(tShaderMode)+".ps")
            Lighting_SpotLightEfects[tIndex,tShaderMode]=Effects[tEffect].ShaderCount
         endif
         Lighting_SpotLights[tSpotLight].ShaderMode=tShaderMode
         tShader=0
         if tShaderMode>0 then tShader=Lighting_SpotLightEfects[tIndex,tShaderMode]
         Lighting_SpotLights[tSpotLight].Shader=Effects[tEffect].Shader[tShader]
         SetObjectShader(Lighting_SpotLights[tSpotLight].Object,Lighting_SpotLights[tSpotLight].Shader)
         LightUpdate(iLight)
      endif
   endif
endfunction

`--------------
` Remove Spot Light
`--------------
function LightsRemoveSpot(iLight as integer)
   if Lighting_Lights[iLight].SpotLight>0
      tSpotLight=Lighting_Lights[iLight].SpotLight
      Lighting_SpotLights[tSpotLight].InUse=0
      if Lighting_SpotLightFreeUp>tSpotLight then Lighting_SpotLightFreeUp=tSpotLight
      Lighting_Lights[iLight].SpotLight=0
      if Lighting_Lights[iLight].ShadowSpot>0 
         Lighting_ShadowSpotLight[Lighting_Lights[iLight].ShadowSpot-1]=0
         Lighting_Lights[iLight].ShadowSpot=0
      endif
      if Lighting_Lights[iLight].Masked>0 then dec Lighting_LightMaskCount[Lighting_Lights[iLight].Masked]
      Lighting_Lights[iLight].Masked=0
      LightUpdate(iLight)
   endif
endfunction


